
--Rain parameters
kPPS = 10;               -- Number of particles generated per second
kGravity =100;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("ring");
  SetBlendMode(kBlendNormal);
  SetNumParticles(1000);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(5500);
TestDone = NewTimeout(9000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-350, -330, 0), Vec3(350,210,0) );
   InitVelocity( "vRange", Vec3(-10, 240, 0), Vec3(10,160, 0) );
   InitScale( "fRange", 1, 1 );
   InitAge("iRange", 0, 0);
   CreateParticles(newParticles);
  end

   Do("move");
   DoAge("iAge");
   DoColor("cFade",
      Color(1, 1,1, 1), 2500,
      Color(1, 1, 1, 0), 1500,
      Color(1, 1, 1, 0));
   DoScale("fScale",
      1, 500,
      1, 500);
   Do("expire", 9000)

DoUp( "vRotate", -.51, .5 );


end

